qui {

noi {
	/*************************************************/
	/***** Step 2.5.2. Trend-demeaned results	    **/
	/*************************************************/
}

	* 2.5.2.1. Compute trend-demeaned estimates
	noi di ""
	noi di "Computing trend-demeaned independence dividend estimates for NIC (/$totalNICs)", _continue
	local count = 0
	cd ..
	foreach cntry of global NICs {
		
	
		* Load estimates
		cd ".\3. Intermediary results\3.4. Intermediaries"
		cap use IDD1_`cntry', clear
		cd ..
		cd ..
		
		if _rc == 0 {
		
			* Track progress
			local count = `count' + 1
			noi di `count', _continue
		
			* Generate necessary variables
			gen TDIDD = .
			gen TDIDD_lower_ci = .
			gen TDIDD_upper_ci = .
			gen TDIDD_pvalue = .
			gen TDIDD_se = .
			
			* Compute trend-demeaned ID's
			sum independence_years if cntrycode == `cntry' & IDD != . & year > $startyear					
			foreach postindependencewindow of numlist 0/`r(max)' {
							
				* Distinguish the period of (maximally) 10 years before the declaration of independence (= pre-treatment period) as well as the period of interest (=post-treatment period):
				gen post = .
				replace post = 1 if cntrycode == `cntry' & independence_years > -1
				replace post = 0 if cntrycode == `cntry' & independence_years < 0
							
				gen treatment = .
				replace treatment = 1 if cntrycode == `cntry'
							
				gen interaction_1 = post * treatment
							
				xi: reg IDD post treatment interaction_1 if cntrycode == `cntry'  & independence_years > -11 & independence_years < 0 & year > $startyear | cntrycode == `cntry'  & independence_years == `postindependencewindow'  & year > $startyear , robust
				mat results = r(table)
							
				replace TDIDD = round(results[1,1],.001) if cntrycode == `cntry' & independence_years == `postindependencewindow' & year > $startyear
				replace TDIDD_lower_ci = results[5,1] if cntrycode == `cntry' & independence_years == `postindependencewindow' & year > $startyear
				replace TDIDD_upper_ci = results[6,1] if cntrycode == `cntry' & independence_years == `postindependencewindow' & year > $startyear
				replace TDIDD_pvalue = round(results[4,1],.001) if cntrycode == `cntry' & independence_years == `postindependencewindow' & year > $startyear
				replace TDIDD_se = round(results[2,1],.001) if cntrycode == `cntry' & independence_years == `postindependencewindow' & year > $startyear
							
				* Drop unnecesaries
				drop post* treatment* interaction*
				}
					
			* Save relevant results
			preserve
			keep cntrycode cntry year independence_years* IDD TDIDD*
			keep if IDD != .
			sort cntrycode year
			cd ".\3. Intermediary results\3.4. Intermediaries"
			save TDIDD1_`cntry', replace
			cd ..
			cd ..
			restore
			}
		}
		
	* 2.5.2.2. Gather all NIC-specific results
	clear all
	foreach cntry of global NICs {
		cd ".\3. Intermediary results\3.4. Intermediaries"
		cap append using TDIDD1_`cntry'
		cd .. 
		cd ..
		}
	keep cntry* year independence_years IDD TDIDD*
	cd ".\4. Master data"
	merge 1:1 cntrycode year using master_data, keepusing(pop)
	drop _merge
	cd ..
	cd ".\3. Intermediary results"
	save TDIDD1, replace
	cd ..
	
	* 2.5.2.3. Plot results
	keep if independence_years >= 0 | independence_years <= 30
	
			* 2.5.2.3.1. Country-specific trend-demaned independence dividend trajectories
			
				* Compute trend-demeaned trajectories prior to independence
				foreach cntry of global NICs {
					sum IDD if cntrycode == `cntry' & independence_years > -11 & independence_years < 0 & year > $startyear
					replace TDIDD = IDD - r(mean) if cntrycode == `cntry' & independence_years < 0 & TDIDD == .
					}
			
				* Compute average trend-demaned independence dividend in each year
				gen agg_TDIDD = .
				foreach year of numlist -10/30 {
					sum TDIDD if independence_years == `year' [w=pop]
					replace agg_TDIDD = `r(mean)'  if independence_years == `year' & TDIDD != . 
					}
			
				* Compute averages prior and after independence
				gen pretrend = .
				sum TDIDD if independence_years >= -10 & independence_years <= -1
				replace pretrend = r(mean) if independence_years < 1
				
				gen posttrend = .
				sum TDIDD if independence_years >= 0 & independence_years <= 30
				replace posttrend = r(mean) if independence_years > -1
			

			* Plot results
			label var independence_years "Years of independence"
			label var agg_TDIDD "Average gap"
			
			foreach i in $NICs {
				local discrepancy  "`discrepancy' line TDIDD independence_years if cntrycode == `i', lc(gs13)  || "
				}
			
			sum cntrycode if independence_years == 30
			local helpme = `r(min)'
			
			sort cntrycode independence_years

			twoway `discrepancy' || ///
					(connected pretrend independence_years, lcolor(red) lpattern(shortdash) lwidth(thin) msymbol(oh) mcolor(red)) || ///
					(connected posttrend independence_years, lcolor(red) lpattern(shortdash) lwidth(thin)  msymbol(oh) mcolor(red)) || ///
					(connected agg_TDIDD independence_years if cntrycode == `helpme', lcolor(gs0) mcolor(gs0)) if independence_years >= -10 & independence_years <= 30, xtitle("Years of independence", size(large)) ytitle("Independence dividend", size(large)) xline(0, lpattern(shortdash) lcolor(gs7) lstyle(foreground)) graphregion(color(white)) bgcolor(white) legend(off) xlab(-10(5)30)
			cd ".\5. TeX results"
			graph export figure4a.pdf, replace
			cd ..
	
	twoway 	(rcap TDIDD_lower_ci TDIDD_upper_ci IDD, horizontal lcolor(gs8)) ///
			(scatter IDD TDIDD, msymbol(Oh) mcolor(gs0) msize(medium)) ///
			(line IDD IDD, lwidth(thick) lcolor(red) lpattern(solid) lwidth(thin)) ///
	, ytitle("Raw independence dividends", size(large)) xtitle("Trend-demeaned independence dividends", size(large)) graphregion(color(white)) bgcolor(white) legend(order(1 "95% confidence interval" 3 "45°-line"))
	cd ".\5. TeX results"
	graph export figureA4_1.pdf, replace
	
	twoway 	(rcap TDIDD_lower_ci TDIDD_upper_ci IDD, horizontal lcolor(gs8)) ///
			(scatter IDD TDIDD, msymbol(Oh) mcolor(gs0) msize(medium)) ///
			(line IDD IDD, lwidth(thick) lcolor(red) lpattern(solid) lwidth(thin)) ///
	if independence_years == 1 , ytitle("Raw independence dividends", size(large)) xtitle("Trend-demeaned independence dividends", size(large)) graphregion(color(white)) bgcolor(white) legend(order(1 "95% confidence interval" 3 "45°-line"))
	graph export figureA4_1_1.pdf, replace
	
	twoway 	(rcap TDIDD_lower_ci TDIDD_upper_ci IDD, horizontal lcolor(gs8)) ///
			(scatter IDD TDIDD, msymbol(Oh) mcolor(gs0) msize(medium)) ///
			(line IDD IDD, lwidth(thick) lcolor(red) lpattern(solid) lwidth(thin)) ///
	if independence_years == 10 , ytitle("Raw independence dividends", size(large)) xtitle("Trend-demeaned independence dividends", size(large)) graphregion(color(white)) bgcolor(white) legend(order(1 "95% confidence interval" 3 "45°-line"))
	graph export figureA4_1_10.pdf, replace
	
	twoway 	(rcap TDIDD_lower_ci TDIDD_upper_ci IDD, horizontal lcolor(gs8)) ///
			(scatter IDD TDIDD, msymbol(Oh) mcolor(gs0) msize(medium)) ///
			(line IDD IDD, lwidth(thick) lcolor(red) lpattern(solid) lwidth(thin)) ///
	if independence_years == 30 , ytitle("Raw independence dividends", size(large)) xtitle("Trend-demeaned independence dividends", size(large)) graphregion(color(white)) bgcolor(white) legend(order(1 "95% confidence interval" 3 "45°-line"))
	graph export figureA4_1_30.pdf, replace
	
	* 2.5.2.4. report overall point estimates + RMSPE
	
		* Report estimates for several independence years
		cd ..
		cd ".\3. Intermediary results\3.4. Intermediaries"
		
		preserve
		clear all
		foreach cntry of global NICs {
			cap append using IDD1_`cntry'
			}
		cd ..
		cd ..
		cd ".\4. Master data"
		merge 1:1 cntrycode year using master_data, keepusing(popshare)
		drop _merge
		cd ..
		gen post = .
		replace post = 1 if independence_years > -1
		replace post = 0 if independence_years < 0
								
		gen treatment = .
		replace treatment = 1
							
		gen interaction_1 = post * treatment
		
		foreach postindependencewindow of numlist 1 5 10 20 30 {
			xi: reg IDD post treatment interaction_1 if independence_years > -11 & independence_years < 0 & year > $startyear | independence_years == `postindependencewindow'  & year > $startyear , robust
			noi di "In postindependence year `postindependencewindow', average independence dividend amounts to", _continue 
			noi di `=round(_b[post],.001)', _continue 
			noi di "(", _continue
			noi di `=round(_se[post],.001)', _continue 
			noi di")"	
			noi di ""
			}
		restore
		
		* Compute RMSPE in full sample, for trend-demeaned estimates
		gen tdrmspe = .

		foreach cntry of global NICs {
		scalar SPE_`cntry' = 0
		scalar total_observations_`cntry' = 0
			foreach year of numlist -10/-1 {
				sum TDIDD if cntrycode == `cntry' & independence_years == `year' & year > $startyear
				if r(mean) != . {
					scalar SPE_`cntry' = SPE_`cntry' + (r(mean)^2)
					scalar total_observations_`cntry' = total_observations_`cntry' + 1
					}
				}
			scalar MSPE_`cntry' = SPE_`cntry'/total_observations_`cntry'
			scalar RMSPE_`cntry' = sqrt(MSPE_`cntry')
			replace tdrmspe = RMSPE_`cntry' if cntrycode == `cntry'
			}
			
		sum tdrmspe if independence_years == 0
		local tdrmspe = round(r(mean), .001)
		sum tdrmspe if independence_years == 0
		local tdrmspe2 = round(r(mean), .001)
		
		noi di ""
		noi di "Unweighted RMSPE for trend-demeaned estimates amounted to `tdrmspe', for average trend-demeaned estimates, it amounted to `tdrmspe2'"

	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
